<?php if ($this->Session->read('Auth.User.account_type') != 'Free') : ?>
    <?php
    /*
      App::uses('Link', 'Model');
      $LinkModel = new Link();
      $LinkModel->deleteAll(array(
      'Link.user_id' => 1,
      'Link.hits' => 0
      )
      );
     */
    ?>

<?php endif; ?>

<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Manage Links
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">
        <div class="pull-left">
            <?php
            // The base url is the url where we'll pass the filter parameters
            $base_url = array('controller' => 'links', 'action' => 'index');
            echo $this->Form->create('Filter', array(
                'url' => $base_url,
                'class' => 'form-inline',
                'inputDefaults' => array(
                    'label' => false,
                    'div' => 'form-group',
                    'class' => 'form-control input-sm',
                    'error' => array(
                        'attributes' => array('wrap' => 'span', 'class' => 'help-block')
                    ),
                ),
            ));
            ?>

            <?php echo $this->Form->input('bundle_id', array('options' => $bundles, 'empty' => __('Bundle'), 'default' => '')); ?>

            <?php echo $this->Form->input('alias', array('type' => 'text', 'size' => 10, 'placeholder' => __('Alias'))); ?>

            <?php echo $this->Form->input('title_desc', array('type' => 'text', 'placeholder' => __('Title, Desc. or URL'))); ?>
            <?php echo $this->Form->submit('Filter', array('div' => false, 'class' => 'btn btn-default btn-sm')); ?>
            <?php echo $this->Html->link('Reset', $base_url); ?>
            <?php echo $this->Form->end(); ?>
        </div>
        
        <div class="pull-right" style="margin-bottom: 5px">
            <?php
            $order = $this->Session->read('PaginationOrder.links');
            $selected_order = implode(':', $order);

            echo $this->Form->create(false, array('class' => 'form-horizontal'));
            echo $this->Form->input('paginationorder', array(
                'options' => array(
                    'Link.created:desc' => 'Newest',
                    'Link.created:asc' => 'Oldest',
                    'Link.clicks:desc' => 'Most Popular',
                    'Link.clicks:asc' => 'Less Popular',
                ),
                'default' => $selected_order,
                'label' => false,
                'div' => false,
                'class' => 'form-control input-sm placeholder-no-fix',
                'onchange' => 'this.form.submit()'
            ));
            echo $this->Form->end();
            ?>
        </div>

        <div class="clearfix"></div>

        <?php foreach ($links as $link) : ?>
            <div class="box box-solid">
                <div class="box-body">
                    <h4>
                        <?php
                        $short_link = $this->Html->url('/'.$link['Link']['alias'], true);
                        if (!empty($link['Link']['title'])) {
                            echo '<a target="_blank" href="' . h($short_link) . '"><span class="glyphicon glyphicon-link"></span> ' . h($link['Link']['title']) . '</a>';
                        } else {
                            echo '<a target="_blank" href="' . h($short_link) . '"><span class="glyphicon glyphicon-link"></span> ' . h($link['Link']['long_url']) . '</a>';
                        }
                        ?>
                    </h4>
                    <p class="text-muted">
                        <small><i class="fa fa-calendar"></i> <?php echo $this->Time->niceShort($link['Link']['created']); ?> - <a target="_blank" href="<?php echo h($link['Link']['long_url']); ?>"><?php echo strtoupper(parse_url($link['Link']['long_url'], PHP_URL_HOST)); ?></a></small>
                    </p>
                    <p class="text-muted">
                        <small>
                            <?php
                            if ($link['Link']['password']) {
                                echo '<i class="fa fa-lock"></i> Protected, ';
                            }
                            ?>
                            <?php
                            if ($link['Bundle']['name']) {
                                ?>
                                <i class="fa fa-tag"></i> <?php echo h($link['Bundle']['name']);
                                ?>, 
                                <?php

                            }
                            ?>
                            <i class="fa fa-hand-o-up"></i> <?php echo $link['Link']['clicks']; ?> Clicks, <i class="fa fa-clock-o"></i> <?php echo $link['Link']['timer']; ?> s, <i class="fa fa-bar-chart-o"></i> <a href="<?php echo $this->Html->url(array('controller' => 'stats', 'action' => 'view', $link['Link']['id'])); ?>">View stats</a>
                        </small>
                    </p>

                    <div class="row">
                        <div class="col-sm-6">
                            <input type="text" class="form-control input-sm" value = "<?php echo $short_link; ?>" readonly onfocus="javascript:this.select()">
                        </div>
                        <div class="col-sm-6">
                            <div class="text-right">
                                <button type="button" class="btn btn-info btn-sm copy-clipboard" data-clipboard-text="<?php echo $short_link; ?>"><i class="fa fa-clipboard"></i> Copy</button>
                                <!-- AddThis Button BEGIN -->
                                <a class="addthis_button btn btn-success btn-sm" addthis:url="<?php echo urlencode($short_link); ?>" addthis:title="<?php echo h($link['Link']['title']); ?>" addthis:description="<?php echo h($link['Link']['description']); ?>" href="http://www.addthis.com/bookmark.php?v=300&amp;pubid=ra-5335bfca1c256beb"><i class="fa fa-share-square-o"></i> Share</a>
                                <!-- AddThis Button END -->

                                <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'links', 'action' => 'edit', $link['Link']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-sm'));
                                ?>

                                <?php if ($this->Session->read('Auth.User.account_type') != 'Free') : ?>
                                    <?php
                                    echo $this->Form->postLink(
                                        '<i class="fa fa-trash-o"></i> Delete',
                                        array('action' => 'delete', $link['Link']['id']),
                                        array('escape' => false, 'class' => 'btn btn-danger btn-sm', 'confirm' => 'Are you sure?')
                                    );
                                    ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <?php unset($link); ?>


        <ul class="pagination">
            <!-- Shows the previous link -->
            <?php echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
            <!-- Shows the page numbers -->
            <?php //echo $this->Paginator->numbers();  ?>
            <?php
            echo $this->Paginator->numbers(array(
                'modulus' => 4,
                'separator' => '',
                'ellipsis' => '<li><a>...</a></li>',
                'tag' => 'li',
                'currentTag' => 'a',
                'first' => 2,
                'last' => 2
            ));
            ?>
            <!-- Shows the next link -->
            <?php echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
        </ul>

        <br />
        <?php echo $this->Paginator->counter(); ?>




    </div>
</div>
<!-- END PAGE CONTENT-->



<script type="text/javascript">var addthis_config = {"ui_click": true};</script>
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5335bfca1c256beb"></script>